
/*************************************************************
**************************************************************
programme pour donner des statistiques d'adéquation d'un modèle logistique
Il sert notamment à calculer le khi2 de la déviance que Stata ne donne pas.
Les autres résultats : nombre de profils et khi2 de Pearson sont aussi donnés mais d'autres commandes de Stata le font aussi (estat gof)

La syntaxe est simplement chi2_res. Cette commande s'applique au modèle de régression logistique qui précède

dernière modification : 9 janvier 2025
**************************************************************
*************************************************************/

/*************************************************************
Exemple avec le fichier geu.dta

logit ct ctub agea i.tabfc afcs ainf
chi2_res

résultats

Statistiques d'adéquation
nombre de profils = 358
khi2 de Pearson (350) = 331.07       p = 0.12
khi2 de la déviance (350) = 380.67   p = 0.12

*************************************************************/
capt program drop chi2_res
program chi2_res


preserve

tempvar pat p m n1 n0

qui predict `pat',number
qui predict `p'

qui bys `pat' : gen `m'=_N if _n==1 & `pat'!=.
qui bys `pat' : egen `n1'=sum(ct) if `pat'!=.
qui bys `pat' : gen `n0'=`m'-`n1' if _n==1 & `pat'!=.

qui sum `pat'
local npat=`r(max)'

local ddl=`npat'-`e(df_m)'-1
local i=0
local khi2=0
local d2=0

*** Calcul des khi2 
* Pearson
while `i' < _N {
local i=`i'+1
if `m'[`i']!=. {
local khi2 =`khi2' + (`n1'[`i']-`m'[`i']*`p'[`i'])^2/(`m'[`i']*`p'[`i']*(1-`p'[`i']))

* déviance
if `n1'[`i']!=0 & `n0'[`i']!=0 {
local d2 = `d2' + 2*(`n1'[`i']*ln(`n1'[`i']/(`m'[`i']*`p'[`i']))+`n0'[`i']*ln(`n0'[`i']/(`m'[`i']*(1-`p'[`i']))))
}
else if `n1'[`i']==0 {
local d2 = `d2' + 2*`m'[`i']*abs(ln(1-`p'[`i']))
}
else if `n0'[`i']==0 {
local d2 = `d2' + 2*`m'[`i']*abs(ln(`p'[`i']))
}


}
}

local khi2 = round(`khi2',.01)
local pvalue = round(chi2tail(`ddl',`khi2'),.01)
local d2 = round(`d2',.01)
local pvalue = round(chi2tail(`ddl',`d2'),.01)


display as text _newline(1) "Statistiques d'adéquation" 

display as text "nombre de profils = " as result `npat' 
display as text "khi2 de Pearson (" as result `ddl' as text ") = " as result `khi2'  as text "       p = " as result %3.2f `pvalue'

display as text "khi2 de la déviance (" as result `ddl' as text ") = " as result `d2'  as text "   p = " as result %3.2f `pvalue'

display _newline(1)


restore

end
